;*** S53MV - KISS+SLIP TNC - SMACK+FLEX CRC - 15/03/2001 ***

;*** Tabela izjem na zacetku ***
zacetek $00040000000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        $00000100000001000000010000000100
        movea.l #$40000,a7 ;ponovno postavi SP
        move.w #8191,d0 ;prepisi EPROM v RAM
        movea.l #0,a0
        movea.l #0,a1
zacete1 move.l (a0)+,(a1)+
        dbf d0,zacete1
        tst.l (#$cccccccc) ;preklopi RD na RAM!!!!!!!!!!!!!!!!!
;!!! Tu ni vec poti nazaj !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        bsr.w meriram ;izmeri dolzino razpolozljivega RAMa
        bsr.w iniblok ;razrezi spomin v bloke
        bsr.w inivmes ;dodeli vmesnike
        bsr.w inirxad ;dodeli bloke in naslove za sprejem
        bsr.w rxaint
        move.l a0,(#aintoff) ;postavi naslov AV INT3
        bsr.w spurint
        move.l a0,(#sintoff) ;postavi naslov AV INT2
        bsr.w rxbint
        move.l a0,(#bintoff) ;postavi naslov AV INT1
        bsr.w iniscc ;inicializacija SCCja
        andi #$f8ff,sr ;prioriteta procesorja 0!!!!!!!!!!!!!!!!
        bsr.w vklopst ;oddaja stanja ob vklopu TNCja
        bra.w gzanka ;glavna zanka programa

;*** Naslovi SCCja Z8530 ***
kanalbc equ $260001 ;SCC#1 naslov B command
kanalbd equ $260003 ;SCC#1 naslov B data
kanalac equ $260005 ;SCC#1 naslov A command
kanalad equ $260007 ;SCC#1 naslov A data
acmdoff equ -2 ;odmik A komande glede na A podatke
bdatoff equ -4 ;odmik B podatkov glede na A podatke
aintoff equ $6c ;odmik A-int v tabeli izjem
sintoff equ $68 ;odmik prazne prekinitve, vektor #2
bintoff equ $64 ;odmik B-int v tabeli izjem

;*** Inicializacija SCCja, A=SDLC, B=UART ***
iniscc  move.b (#kanalac),d0 ;precita RR0, resetira kazalce
        moveq #5,d0 ;popolni reset SCCja
        lea #4(pc),a0
        bra.b iniscc1
        $09c0 ;WR9 popolni reset SCCja
        $0200 ;WR2 INT vector #0
        $0900 ;WR9 status low, izkljucen MIE
iniscc1 move.b (a0)+,(#kanalac)
        nop
        dbf d0,iniscc1
        moveq #35,d0 ;inicializacija kanala A (megabit)
        lea #4(pc),a0
        bra.b iniscc2
        $04e0 ;WR4 SDLC mode
        $0100 ;WR1 INT disable
        $0aa0 ;WR10 CRC preset 1, NRZI, flag idle
        $077e ;WR7 flag
        $03c8 ;WR3 RX 8bits/character
        $0561 ;WR5 TX 8bits/character, SDLC CRC
        $0e62 ;WR14 disable DPLL & BRG, PCLK>BRG, DTR
        $0b07 ;WR11 NOXTAL, RTxC>RXclk=TXclk, DPLL>TRxC
        $0c01 ;WR12 BRG lower byte ;76.8kbps @ 29.4912MHz CLK
        $0d00 ;WR13 BRG upper byte
        $0ee2 ;WR14 set NRZI mode, DTR
        $0e82 ;WR14 set source = BR generator (PCLK), DTR
        $0e22 ;WR14 enter DPLL search mode, DTR
        $0e03 ;WR14 enable BRG, DTR
        $03c9 ;WR3 RX enable
        $0569 ;WR5 TX enable, brez RTS!!!
        $0f80 ;WR15 break/abort IE
        $01f9 ;WR1 DMA RX, RX INT on special condition, EXT INT
iniscc2 move.b (a0)+,(#kanalac)
        nop
        dbf d0,iniscc2
        moveq #27,d0 ;inicializacija kanala B (UART)
        lea #4(pc),a0
        bra.b iniscc3
        $0444 ;WR4 async mode, no parity, 1 stop bit, x16 clk
        $0100 ;WR1 INT disable
        $0a00 ;WR10 NRZ
        $03c0 ;WR3 RX 8bits/character
        $0560 ;WR5 TX 8bits/character
        $0e62 ;WR14 disable DPLL & BRG, DTR, PCLK>BRG
        $0b06 ;WR11 NOXTAL, RTxC>RXclk=TXclk, BRG>TRxC
        $0c00 ;WR12 BRG lower byte ;230.4kbps @ 29.4912MHz CLK
        $0d00 ;WR13 BRG upper byte
        $0e03 ;WR14 DTR, enable BRG
        $03c1 ;WR3 RX enable
        $056a ;WR5 TX enable, RTS
        $0f00 ;WR15 disable INT
        $01e0 ;WR1 DMA RX, all INT off
iniscc3 move.b (a0)+,(#kanalbc)
        nop
        dbf d0,iniscc3
        rts

;*** Okvir iz SCC-RXA ***
rxablok $0000     ;blok sprejemnika A (.W)
smeti   $0000     ;blok za v smeti (.W)
rxvmes  $00000000 ;naslov sprejemnega vmesnika A+B (.L)
rxaokv  move.b #3,(#kanalac) ;RR3 preglej stanje SCC RX
        move.b (#kanalac),d0
        andi.b #$28,d0 ;SCC RXIP & EXTSTATIP?
        bne.b rxaokv1
        rts
rxaokv1 move.b #3,(#kanalac) ;WR3 RX disable
        move.b #$c8,(#kanalac)
        clr.w d1 ;pobrisi dolzino okvirja v D1.W
        andi.b #$08,d0 ;break/abort IP?
        bne.b rxaokv2
        move.b #1,(#kanalac) ;RR1 - kontrola sprejetega okvirja
        move.b (#kanalac),d0
        andi.b #$ee,d0
        cmpi.b #$86,d0
        bne.b rxaokv2
        move.w #maxdol,d1 ;izracunaj dolzino okvirja v D1.W
        sub.w d7,d1
        subq.w #2,d1 ;odsteje CRC znaka viska
        bpl.b rxaokv2
        clr.w d1
rxaokv2 move.b #$30,(#kanalac) ;WR0 error reset command
        move.b #$10,(#kanalac) ;WR0 reset ext/status interrupt
        cmpi.w #mindol,d1 ;pravilno sprejeti okvir?
        bcs.b rxaokv3
        move.w (#rxablok),d0 ;sprejeti blok v vmesnik?
        move.w (#smeti),d2
        cmp.w d2,d0
        beq.b rxaokv4
        bsr.w naslov
        move.w d1,(a0)
        move.w (#rxablok),d0
        movea.l (#rxvmes),a0
        bsr.w okvirvv
rxaokv4 bsr.w dodeli ;dodeli nov blok za sprejemnik
        move.w d0,(#rxablok)
        bne.b rxaokv3
        move.w (#smeti),(#rxablok)
rxaokv3 move.w (#rxablok),d0 ;postavi naslove sprejemnika
        bsr.w naslov
        move.w #1,#rxkanal(a0)
        adda.w #zacokv,a0
        movea.l a0,a5
        move.w #maxdol,d7
        move.b #3,(#kanalac) ;WR3 RX enable
        move.b #$c9,(#kanalac)
        rts

;*** Preklop sprejem/oddaja kanala A ***
txastat $0000      ;stanje oddajnika A (.W)
txastev $00000000  ;stevec oddaanika A (.L)
txablok $0000      ;blok oddajnika A (.W)
txavmes $00000000  ;vmesnik oddajnika A (.L)
txakuza equ 123456 ;kuzapazi oddajnika A
txaprek move.w (#txastat),d0 ;stanje 0 - sprejem
        bne.w txapre6
        bsr.w rxaokv
        movea.l (#txavmes),a0 ;cakajoci okvirji za oddajo?
        move.w (a0)+,d0
        cmp.w (a0),d0
        bne.b txapre1
        rts
txapre1 move.l (#milisek),d0 ;nakljucno cakanje za oddajo?
        sub.l (#txastev),d0
        cmp.l (#txaglav),d0
        bcc.b txapre2
        rts
txapre2 move.l (#milisek),(#txastev) ;resetira stevec
        btst #3,(#kanalac) ;pogleda in caka na DCD?
        beq.b txapre4
        rts
txapre4 bsr.w psevnak ;tecnoba se primerja s psevdonak. stev.
        cmp.b (#tecnoba),d0
        bcs.b txapre5
        rts
txapre5 move.b #3,(#kanalac) ;WR3 RX disable
        move.b #$c8,(#kanalac)
        move.b #5,(#kanalac) ;WR5 vkljuci RTS!!!
        move.b #$6b,(#kanalac)
        move.l (#milisek),(#txastev)
        move.w #1,(#txastat) ;preklop v stanje 1 oddaja glave
        rts
txapre6 subq.w #1,d0 ;stanje 1 - oddaja sinhronizacijske glave
        bne.b txapre8
        move.l (#milisek),d0 ;kontrola casa?
        sub.l (#txastev),d0
        cmp.l (#txaglav),d0
        bcc.b txapre7
        rts ;cas se se ni iztekel
txapre7 move.b #$30,(#kanalac) ;WR0 error reset
        move.w #2,(#txastat) ;preklop v stanje 2 priprava tx
        rts
txapre8 subq.w #1,d0 ;stanje 2 - priprava okvirja za oddajo
        bne.b txapre9
        movea.l (#txavmes),a0
        bsr.w izokvir
        move.w d0,(#txablok) ;stevilka okvirja, konec oddaje?
        beq.w txapr13
        move.b #$30,(#kanalac) ;WR0 error reset
        bsr.w naslov ;postavi naslove oddajnega bloka
        move.w (a0),d7
        subq.w #1,d7
        move.w #rxkanal(a0),d0
        adda.w d0,a0
        movea.l a0,a5
        bsr.w txaint ;postavi naslov oddajne prekinitve
        move.l a0,(#aintoff)
        move.b #$80,(#kanalac) ;reset TX CRC generator
        move.b #1,(#kanalac) ;WR1 vkljuci TX DMA request
        move.b #$d9,(#kanalac)
        move.l (#milisek),(#txastev)
        move.w #3,(#txastat) ;preklop v stanje 3 oddaja okvirja
        rts
txapre9 subq.w #1,d0 ;stanje 3 - oddaja okvirja
        bne.b txapr11
        move.l (#milisek),d0
        sub.l (#txastev),d0
        cmpi.l #txakuza,d0
        bcc.b txapr10
        tst.w d7
        bmi.b txapr10
        rts
txapr10 move.l (#milisek),(#txastev)
        move.w #4,(#txastat) ;preklop v stanje 4 oddaja repa
        rts
txapr11 move.l (#milisek),d0 ;stanje 4 - oddaja repa
        sub.l (#txastev),d0
        cmp.l (#txarep),d0
        bcc.b txapr12
        rts
txapr12 move.w (#txablok),d0 ;sprosti oddani blok
        bsr.w sprosti
        move.w #2,(#txastat) ;preklop v stanje 2 priprava tx
        rts
txapr13 clr.w (#txastat) ;preklop v stanje 0 - sprejem
        move.b #5,(#kanalac) ;WR5 RTS izkljuci oddajnik
        move.b #$69,(#kanalac)
        bsr.w rxaint ;postavi naslov sprejemne prekinitve
        move.l a0,(#aintoff)
        move.w (#rxablok),d0 ;naslov sprejemnega bloka
        bsr.w naslov
        adda.w #zacokv,a0
        movea.l a0,a5
        move.w #maxdol,d7
        move.b #1,(#kanalac) ;WR1 vkljuci RX DMA request
        move.b #$f9,(#kanalac)
        move.b #3,(#kanalac) ;WR3 RX enable
        move.b #$c9,(#kanalac)
        rts

;*** Prekinitve SCC-TXA, neposredna uporaba A4,A5,D7 ***
txaint  lea #4(pc),a0 ;naslov prekinitve v A0
        rts
        move.b (a5)+,(a6) ;prekinitveni podprogram
        subq.w #1,d7
        bmi.b txaint1
        rte
txaint1 move.b #$c0,#acmdoff(a6) ;reset TX underrun/eom latch
        nop
        move.b #1,#acmdoff(a6) ;WR1 DMA request disable
        nop
        move.b #$59,#acmdoff(a6)
        rte

;*** Prekinitve SCC-RXA, neposredna uporaba A5,A6,D7 ***
rxaint  lea #4(pc),a0 ;naslov prekinivte v A0
        rts
        subq.w #1,d7 ;prekinitveni podprogram
        bmi.b rxaint1
        move.b (a6),(a5)+
        rte
rxaint1 clr.w d7
        tst.b (a6)
        rte

;*** Prekinitve SCC-RXB, neposredna uporaba A4,A6,D6 ***
rxbint  lea #4(pc),a0 ;naslov prekinitve v A0
        rts
        move.b #bdatoff(a6),#0(a4,d6.w) ;prekinitveni podprog.
        subq.w #1,d6
        bmi.b rxbint1
        rte
rxbint1 addi.w #dolblok,d6
        rte

;*** Prazni prekinitveni podprogram ***
spurint lea #4(pc),a0 ;naslov prekinitve v A0
        rts
        rte

;*** KISS oddaja okvirjev na kanalu B + izracun CRC ***
txbstat $0001     ;stanje oddajnika B (.W) zacetno stanje 1 !
txbvmes $00000000 ;vmesnik oddajnika B (.L)
txbblok $0000     ;blok oddajnika B (.W)
txbbadd $00000000 ;naslov oddajnega bloka (.L)
fend    equ $c0
fesc    equ $db
tfend   equ $dc
tfesc   equ $dd
kisstx  btst #2,(#kanalbc) ;oddajnik B razpolozljiv?
        bne.b kisstx1
        rts
kisstx1 move.w (#txbstat),d0 ;stanje 0 - oddaja vsebine + CRC
        bne.b kisstx6
        movea.l (#txbbadd),a0 ;konec znakov v okvirju?
        subq.w #1,(a0)
        bmi.b kisstx3
        move.w #rxkanal(a0),d0 ;znak iz okvirja za oddajo
        move.b #0(a0,d0.w),d1
        addq.w #1,#rxkanal(a0) ;povecaj kazalec
        bsr.w obrtcrc
kisstx2 cmpi.b #fend,d1 ;posebni znak FEND?
        beq.b kisstx4
        cmpi.b #fesc,d1 ;posebni znak FESC?
        beq.b kisstx5
        move.b d1,(#kanalbd) ;oddaja navadnega znaka
        rts
kisstx3 bsr.w oddtcrc ;oddaja oddajnega CRCja na koncu okvirja
        tst.w d0
        bne.b kisstx2
        move.w #6,(#txbstat) ;preklop v stanje 6
        rts
kisstx4 move.b #fesc,(#kanalbd) ;FEND - preklop v stanje 4
        move.w #4,(#txbstat)
        rts
kisstx5 move.b d1,(#kanalbd) ;FESC - preklop v stanje 5
        move.w #5,(#txbstat)
        rts
kisstx6 subq.w #1,d0 ;stanje 1 - cakanje na okvir
        bne.b kisstx9
        movea.l (#txbvmes),a0
        bsr.w izokvir
        tst.w d0
        bne.b kisstx7
        rts
kisstx7 move.w d0,(#txbblok) ;postavi stevilko in naslov
        bsr.w naslov
        move.l a0,(#txbbadd) ;postavi naslov oddajnega bloka
        tst.w #tipokv(a0)
        bmi.b kisstx8
        bsr.w initcrc ;inicializacija oddajnega CRCja
        move.w #2,(#txbstat) ;preklop v stanje 2
        rts
kisstx8 move.w #7,(#txbstat) ;preklop v stanje 7
        rts
kisstx9 subq.w #1,d0 ;stanje 2 - oddaja FEND na zacetku
        bne.b kisst11
        move.b #fend,(#kanalbd)
        movea.l (#txbbadd),a0 ;ali okvir rabi zacetni znak?
        tst.w #tipokv(a0)
        bne.b kisst10
        move.w #3,(#txbstat) ;preklop v stanje 3
        rts
kisst10 clr.w (#txbcrcs) ;brez zacetnega znaka in brez CRCja
        clr.w (#txbstat) ;preklop v stanje 0
        rts
kisst11 subq.w #1,d0 ;stanje 3 - oddaja zacetnega znaka okvirja
        bne.b kisst12
        move.b (#txbznak),(#kanalbd)
        clr.w (#txbstat) ;preklop v stanje 0
        rts
kisst12 subq.w #1,d0 ;stanje 4 - oddaja TFEND za FESC
        bne.b kisst13
        move.b #tfend,(#kanalbd)
        clr.w (#txbstat) ;preklop v stanje 0
        rts
kisst13 subq.w #1,d0 ;stanje 5 - oddaja TFESC za FESC
        bne.b kisst14
        move.b #tfesc,(#kanalbd)
        clr.w (#txbstat) ;preklop v stanje 0
        rts
kisst14 subq.w #1,d0 ;stanje 6 - FEND, sprosti!
        bne.b kisst15
        move.b #fend,(#kanalbd)
        move.w (#txbblok),d0
        bsr.w sprosti
        move.w #1,(#txbstat) ;preklop v stanje 1
        rts
kisst15 movea.l (#txbbadd),a0 ;stanje 7 - oddaja ASCII okvirja
        subq.w #1,(a0)
        bmi.b kisst16
        move.w #rxkanal(a0),d0
        move.b #0(a0,d0.w),(#kanalbd)
        addq.w #1,#rxkanal(a0)
        rts
kisst16 move.w (#txbblok),d0 ;konec ASCII znakov, sprosti!
        bsr.w sprosti
        move.w #1,(#txbstat) ;preklop v stanje 1
        rts

;*** Inicializacija oddajnega CRCja ***
txbctab $00000000 ;naslov tabele oddanega CRCja (.L)
txbcrcw $0000     ;obracunani oddajni CRC (.W)
txbcrcs $0000     ;stevec oddaje CRCja (.W)
initcrc cmpi.b #smack,(#txbznak) ;SMACK CRC?
        bne.b initcr1
        move.l #scrctab,(#txbctab) ;tabela za SMACK CRC
        move.w #sinicrc,(#txbcrcw)
        move.w #2,(#txbcrcs)
        rts
initcr1 cmpi.b #flex,(#txbznak) ;FLEX CRC?
        bne.b initcr2
        move.l #fcrctab,(#txbctab) ;tabela za FLEX CRC
        move.w #finicrc,(#txbcrcw)
        move.w #2,(#txbcrcs)
        rts
initcr2 clr.w (#txbcrcs)
        move.b #nicla,(#txbznak) ;pocisti napacni txbznak
        rts

;*** Obracun CRCja na oddanem znaku D1.B ***
obrtcrc tst.w (#txbcrcs)
        bne.b obrtcr1
        rts
obrtcr1 movea.l (#txbctab),a2 ;obracun CRCja za oddani bajt
        move.w (#txbcrcw),d3
        move.b d1,d0
        eor.w d3,d0
        andi.w #255,d0
        add.w d0,d0
        move.w #0(a2,d0.w),d2
        lsr.w #8,d3
        eor.w d2,d3
        move.w d3,(#txbcrcw)
        rts

;*** Oddaja oddajnega CRCja v D1.B, zastavica D0.W ***
oddtcrc move.w (#txbcrcs),d0 ;konec/brez CRCja?
        bne.b oddtcr1
        rts
oddtcr1 move.w (#txbcrcw),d1
        cmpi.w #1,d0 ;oddaja drugega:gornjega bajta CRC?
        bne.b oddtcr2
        lsr.w #8,d1
        clr.w (#txbcrcs)
        rts
oddtcr2 move.w #1,(#txbcrcs) ;oddaja prvega:spodnjega bajta CRC
        rts

;*** Tabela za izracun SMACK CRCja (256*.W) ***
smack   equ $80 ;zacetni znak za SMACK okvir
sinicrc equ $a001
scrctab $0000c0c1c1810140c30103c00280c241
        $c60106c00780c7410500c5c1c4810440
        $cc010cc00d80cd410f00cfc1ce810e40
        $0a00cac1cb810b40c90109c00880c841
        $d80118c01980d9411b00dbc1da811a40
        $1e00dec1df811f40dd011dc01c80dc41
        $1400d4c1d5811540d70117c01680d641
        $d20112c01380d3411100d1c1d0811040
        $f00130c03180f1413300f3c1f2813240
        $3600f6c1f7813740f50135c03480f441
        $3c00fcc1fd813d40ff013fc03e80fe41
        $fa013ac03b80fb413900f9c1f8813840
        $2800e8c1e9812940eb012bc02a80ea41
        $ee012ec02f80ef412d00edc1ec812c40
        $e40124c02580e5412700e7c1e6812640
        $2200e2c1e3812340e10121c02080e041
        $a00160c06180a1416300a3c1a2816240
        $6600a6c1a7816740a50165c06480a441
        $6c00acc1ad816d40af016fc06e80ae41
        $aa016ac06b80ab416900a9c1a8816840
        $7800b8c1b9817940bb017bc07a80ba41
        $be017ec07f80bf417d00bdc1bc817c40
        $b40174c07580b5417700b7c1b6817640
        $7200b2c1b3817340b10171c07080b041
        $500090c191815140930153c052809241
        $960156c057809741550095c194815440
        $9c015cc05d809d415f009fc19e815e40
        $5a009ac19b815b40990159c058809841
        $880148c0498089414b008bc18a814a40
        $4e008ec18f814f408d014dc04c808c41
        $440084c185814540870147c046808641
        $820142c043808341410081c180814040

;*** Tabela za izracun FLEX CRCja (256*.W) ***
flex    equ $20 ;zacetni znak za FLEX okvir
finicrc equ $fdde
fcrctab $870F0E1E952C1C3DA3492A58B16A387B ;tabela CRCja 256*.W
        $CF834692DDA054B1EBC562D4F9E670F7
        $061F8F0E143C9D2D2259AB48307AB96B
        $4E93C7825CB0D5A16AD5E3C478F6F1E7
        $852E0C3F970D1E1CA1682879B34B3A5A
        $CDA244B3DF815690E9E460F5FBC772D6
        $043E8D2F161D9F0C2078A969325BBB4A
        $4CB2C5A35E91D78068F4E1E57AD7F3C6
        $834D0A5C916E187FA70B2E1AB5283C39
        $CBC142D0D9E250F3EF876696FDA474B5
        $025D8B4C107E996F261BAF0A3438BD29
        $4AD1C3C058F2D1E36E97E7867CB4F5A5
        $816C087D934F1A5EA52A2C3BB7093E18
        $C9E040F1DBC352D2EDA664B7FF857694
        $007C896D125F9B4E243AAD2B3619BF08
        $48F0C1E15AD3D3C26CB6E5A77E95F784
        $8F8B069A9DA814B9ABCD22DCB9EE30FF
        $C7074E16D5245C35E3416A50F1627873
        $0E9B878A1CB895A92ADDA3CC38FEB1EF
        $4617CF065434DD256251EB407072F963
        $8DAA04BB9F891698A9EC20FDBBCF32DE
        $C5264C37D7055E14E1606871F3437A52
        $0CBA85AB1E99978828FCA1ED3ADFB3CE
        $4436CD275615DF046070E9617253FB42
        $8BC902D899EA10FBAF8F269EBDAC34BD
        $C3454A54D1665877E7036E12F5207C31
        $0AD983C818FA91EB2E9FA78E3CBCB5AD
        $4255CB445076D9676613EF027430FD21
        $89E800F99BCB12DAADAE24BFBF8D369C
        $C1644875D3475A56E5226C33F7017E10
        $08F881E91ADB93CA2CBEA5AF3E9DB78C
        $4074C9655257DB466432ED237611FF00

;*** Inicializacija sprejemnega CRCja ***
rxbctab $00000000 ;naslov tabele sprejemnega CRCja (.L)
rxbcrcw $0000     ;obracunani sprejemni CRC (.W)
rxbcrcs $0000     ;stevec sprejema CRCja (.W)
rxbcrcz $0000     ;zadnja dva znaka okvirja s CRCjem (.W)
inircrc move.w #2,(#rxbcrcs) ;stevec za prva dva znaka
        cmpi.b #smack,(#rxbznak) ;SMACK CRC
        bne.b inircr1
        move.l #scrctab,(#rxbctab) ;tabela za SMACK CRC
        move.w #sinicrc,(#rxbcrcw)
        rts
inircr1 cmpi.b #flex,(#rxbznak) ;FLEX CRC?
        bne.b inircr2
        move.l #fcrctab,(#rxbctab) ;tabela za FLEX CRC
        move.w #finicrc,(#rxbcrcw)
        rts
inircr2 clr.b (#rxbznak) ;izbrisi vse ostale rxbznak
        rts

;*** Obracun CRCja na sprejetem znaku D1.B, predpredzadnji ***
obrrcrc tst.b (#rxbznak)
        bne.b obrrcr1
        rts
obrrcr1 move.w (#rxbcrcz),d3 ;zakasnitev dveh znakov za CRC
        move.b d3,d0
        move.b d1,d3
        rol.w #8,d3
        move.w d3,(#rxbcrcz)
        tst.w (#rxbcrcs) ;ne obracunavaj prvih dveh znakov!
        beq.b obrrcr2
        subq.w #1,(#rxbcrcs)
        rts
obrrcr2 movea.l (#rxbctab),a2 ;obracun CRCja za sprejeti bajt
        move.w (#rxbcrcw),d3
        eor.w d3,d0
        andi.w #255,d0
        add.w d0,d0
        move.w #0(a2,d0.w),d2
        lsr.w #8,d3
        eor.w d2,d3
        move.w d3,(#rxbcrcw)
        rts

;*** Primerjaj sprejeti/obracunani CRC, odstej CRC (A0) ***
tstrcrc tst.b (#rxbznak)
        bne.b tstrcr1
        rts
tstrcr1 move.w (#rxbcrcw),d3 ;prim. sprejeti in obracunani CRC
        cmp.w (#rxbcrcz),d3
        bne.b tstrcr2
        subq.w #2,(a0) ;odstej dva CRC znaka od dolzine okvirja
        bmi.b tstrcr2
        rts
tstrcr2 clr.w (a0) ;pobrisi dolzino napacno sprejetega okvirja
        rts

;*** KISS sprejem okvirjev na kanalu B + preverjanje CRC ***
rxbstev $0000     ;stevec sprejemnika B (.W)
rxbstat $0002     ;stanje sprejemnika B (.W) zacetno stanje 2 !
rxbblok $0000     ;blok sprejemnika B (.W)
rxbbadd $00000000 ;naslov bloka sprejemnika B (.L)
rxbznak $0000     ;zastavica za okvir s CRCjem (.B)
nicla   equ 0     ;zacetni znak za KISS okvir $00
slip    equ 69    ;zacetni znak za SLIP okvir $45
slipm   equ 11    ;meja podrocja SLIP znakov $45-$4F
kissrx  move.w (#rxbstev),d0 ;nov znak iz RXB int?
        cmp.w d6,d0
        bne.b kissrx1
        rts
kissrx1 move.b #0(a4,d0.w),d1 ;nov znak v D1.B, nov kazalec
        subq.w #1,d0
        bpl.b kissrx2
        addi.w #dolblok,d0
kissrx2 move.w d0,(#rxbstev)
        bsr.b kissrx3
        bra.b kissrx ;ponavljaj dokler so znaki v vmesniku
kissrx3 move.w (#rxbstat),d0 ;stanje 0 - RX navadnih znakov?
        bne.b kissrx8
        cmpi.b #fend,d1 ;FEND na koncu okvirja?
        beq.b kissrx5
        cmpi.b #fesc,d1 ;znak FESC?
        beq.b kissrx7
kissrx4 movea.l (#rxbbadd),a0 ;naslov sprejemnega okvirja
        move.w (a0),d0
        cmpi.w #maxdol,d0 ;max dolzina okvirja? zakljuci visek!
        bcc.b kissrx5
        move.b d1,#zacokv(a0,d0.w) ;nov znak v okvir
        addq.w #1,(a0)
        bra.w obrrcrc ;obracun sprejemnega CRCja (vsebuje RTS!)
kissrx5 move.w #2,(#rxbstat) ;znak FEND - preklop v stanje 2
        movea.l (#rxbbadd),a0
        bsr.w tstrcrc ;preverjanje sprejetega CRCja
        move.w (#rxbblok),d0
        cmpi.w #mindol,(a0) ;sprosti prekratek okvir?
        bcc.b kissrx6
        bsr.w sprosti
        rts
kissrx6 movea.l (#rxvmes),a0 ;okvir v sprejemni vmesnik
        bsr.w okvirvv
        rts
kissrx7 move.w #1,(#rxbstat) ;znak FESC - preklop v stanje 1
        rts
kissrx8 subq.w #1,d0 ;stanje 1 - prekodiranje FEND in FESC
        bne.b kissr10
        clr.w (#rxbstat) ;stanje 1 - povratek v 0!
        cmpi.b #tfend,d1 ;znak TFEND? - pretvori v FEND
        bne.b kissrx9
        move.b #fend,d1
        bra.b kissrx4
kissrx9 cmpi.b #tfesc,d1 ;znak TFESC? - pretvori v FESC
        bne.b kissrx5 ;zakljuci okvir v slucaju napake
        move.b #fesc,d1
        bra.b kissrx4
kissr10 subq.w #1,d0 ;stanje 2 - cakanje zacetni FEND?
        bne.b kissr12
        cmpi.b #fend,d1
        beq.b kissr11
        bsr.w okodgov ;odgovori na nestandarne znake (D1.B)
        rts
kissr11 move.w #3,(#rxbstat) ;preklop v stanje 3
        rts
kissr12 cmpi.b #fend,d1 ;stanje 3 - cakanje na zacetni znak
        bne.b kissr13 ;se en FEND? - ostani v 3!
        rts
kissr13 moveq #1,d2 ;oznaka SLIP okvirjev
        move.b d1,d0 ;zacetni znak SLIP okvirja?
        sub.b #slip,d0
        cmpi.b #slipm,d0
        bcs.b kissr14
        moveq #0,d2 ;oznaka KISS okvirjev
        cmpi.b #flex,d1 ;zacetni znak za FLEX?
        beq.b kissr14
        cmpi.b #smack,d1 ;zacetni znak za SMACK?
        beq.b kissr14
        cmpi.b #nicla,d1 ;zacetna nicla za obicajni KISS?
        beq.b kissr14
        bsr.w okodgov ;odgovori na nestandardne znake (D1.B)
        move.w #2,(#rxbstat) ;nazaj v stanje 2, cakaj FEND
        rts
kissr14 move.b d1,(#rxbznak) ;zastavica za okvir s CRCjem
        move.w d2,-(a7)
        bsr.w dodeli ;dodeli nov blok za sprejem RXB
        move.w (a7)+,d2
        tst.w d0
        bne.b kissr15
        move.w #2,(#rxbstat) ;nazaj v stanje 2, ko ni bloka!
        rts
kissr15 move.w d0,(#rxbblok) ;nov sprejemni blok
        bsr.w naslov
        move.l a0,(#rxbbadd)
        clr.w (a0)
        move.w #2,#rxkanal(a0)
        move.w d2,#tipokv(a0) ;nastavi in preveri tip okvirja
        beq.b kissr16
        move.b (#rxbznak),#zacokv(a0) ;vrini prvi byte v okvir
        move.w #1,(a0)
kissr16 bsr.w inircrc ;inicializacija sprejemnega CRCja
        clr.w (#rxbstat) ;preklop v stanje 0
        rts

;*** Odgovori na vse nestandardne znake (D1.B) ***
okodgov cmpi.b #13,d1 ;odgovori na <CR>
        beq.b okodgo1
        cmpi.b #43,d1 ;odgovori na "+"
        beq.b okodgo1
        rts
okodgo1 bsr.w dodeli ;dodeli blok odgovora, blok razpolozljiv?
        move.w d0,d5
        bne.b okodgo2
        rts
okodgo2 bsr.w naslov ;sestavi odgovor v ASCII okvirju
        move.w #-1,#tipokv(a0)
        move.w #zacokv,#rxkanal(a0)
        move.l a0,-(a7)
        adda.w #zacokv,a0 ;prepisi pripravljeni odgovor v okvir
        movea.l #okodgo3,a1
        bsr.w tekst
        move.l a0,d0 ;izracunaj dolzino sestavljenega okvirja
        movea.l (a7)+,a0
        sub.l a0,d0
        sub.w #zacokv,d0
        move.w d0,(a0)
        move.w d5,d0 ;okvir v oddajo na RS-232
        move.l (#txbvmes),a0
        bsr.w okvirvv
        rts
okodgo3 '^M^JOK^M^JCONNECT^M^J'

;*** Doloci zacetek in dolzino razpolozljivega spomina ***
zacram  $00001800 ;zacetek RAMa
dolram  $0000e000 ;dolzina RAMa - najmanj samo 64kb
ramlov0 equ $f000
ramlov1 equ $1f000
ramlov2 equ $2f000
meriram move.l #0,(#ramlov1)
        move.l #0,(#ramlov2)
        move.l #-1,(#ramlov0) ;poglej, katerega povozi!
        tst.l (#ramlov1)
        beq.b merira2
        tst.l (#ramlov2)
        beq.b merira1
        rts
merira1 addi.l #$10000,(#zacram) ;srednji 128kb brez A16
        addi.l #$10000,(#dolram)
        rts
merira2 tst.l (#ramlov2)
        beq.b merira3
        addi.l #$10000,(#dolram) ;spodnji 128kb brez A17
        rts
merira3 addi.l #$30000,(#dolram) ;najvec vseh 256kb
        rts

;*** Nastavljeni parametri v CMOS RAMu ***
mojznak equ $3f900 ;klicni znak TNCja (6*.B)
mojssid equ $3f90c ;ssid za digi TNCja (.B)
txaglav equ $3f910 ;dolzina sinhronizacijske glave A (.L)
txarep  equ $3f914 ;dolzina repa okvirja A (.L)
tecnoba equ $3f918 ;tecnoba oddajnika A (.B)
txbznak equ $3f91c ;zacetni znak RS-232 okvirja B (.B)
defpot  equ $3f920 ;default AX.25 pot SLIP okvirjev (.W+70*.B)
arpstat equ $3f97c ;0=izklop, 1=beri, 2=default, 3=vpis (.W)
arpzac  equ $3f980 ;zacetek ARP tabele (maxarp*arpblok*.B)

;*** Razrezi spomin v bloke in postavi zastavice ***
zastave $0000 ;dolzina zastavic (.W)
zastkaz $0000 ;kazalec na naslednji prost blok (.W)
dolblok equ 2048 ;dolzina enega bloka, mora biti potenca 2!!!!!
dolbexp equ 3 ;binarni eksponent-8 dolzine bloka, glej dolblok
dolvmes equ 300 ;dolzina vmesnika v bajtih (max: dolblok-4)
;dolzina okvirja na zacetku (offset=0) (.W)
rxkanal equ 2 ;offset RX kanala, na oddaji zacetek (.W)
tipokv  equ 4 ;vrsta okvirja B: 0=KISS, 1=SLIP, -1=ASCII (.W)
zacokv  equ 96 ;offset vsebine okvirja
maxdol  equ 1920 ;max dolzina vsebine okvirja
mindol  equ 15 ;min dolzina vsebine okvirja
iniblok move.l (#dolram),d0 ;izracunaj stevilo blokov
        divu #dolblok,d0
        subq.w #1,d0
        movea.l (#zacram),a0 ;postavi zastavice blokov
        clr.w d1
iniblo2 tst.w d0
        beq.b iniblo5
        addq.w #4,d1
        moveq #31,d2
        clr.l d3
iniblo3 lsr.l #1,d3
        bset #31,d3
        subq.w #1,d0
        dbeq d2,iniblo3
iniblo4 move.l d3,(a0)+
        bra.b iniblo2
iniblo5 move.w d1,(#zastave)
        rts

;*** Izracunaj naslov bloka stevilka D0.W v A0 ***
naslov  movea.l (#zacram),a0
        ext.l d0
        lsl.l #8,d0
        lsl.l #dolbexp,d0
        adda.l d0,a0
        rts

;*** Sprosti blok stevilka D0.W v spominu ***
sprosti subq.w #1,d0 ;preverjanje stevilke bloka?
        bmi.b sprost1
        movea.l (#zacram),a0
        move.w d0,d1
        lsr.w #3,d1
        adda.w d1,a0
        andi.w #7,d0
        moveq #-128,d1
        ror.b d0,d1
        or.b d1,(a0)
sprost1 rts

;*** Dodeli prost blok spomina, vrni stevilko bloka v D0.W ***
dodeli  move.w (#zastave),d1
        move.w d1,d3
        lsr.w #2,d1
        movea.l (#zacram),a0
        move.w (#zastkaz),d2
        clr.w d0 ;nicla pomeni, da ni prostega bloka....
        bra.b dodeli2 ;zanka isce nenicelno skupino zastavic
dodeli1 addq.w #4,d2
dodeli2 andi.w #-4,d2 ;kontrola kazalca na zastavice
        cmp.w d3,d2
        bcs.b dodeli3
        clr.w d2
dodeli3 move.l #0(a0,d2.w),d4
        dbne d1,dodeli1
        beq.b dodeli4 ;ni prostega bloka v skupini 32?
        move.w d2,d0
        lsl.l #3,d0
        moveq #31,d1 ;poisce prosti blok v skupini 32 zastvic
dodeli5 addq.w #1,d0
        lsl.l #1,d4
        dbcs d1,dodeli5
        rol.l d1,d4 ;zavrti d4 nazaj v prvotni polozaj
        move.l d4,#0(a0,d2.w)
dodeli4 move.w d2,(#zastkaz)
        rts

;*** Izracunaj stevilo prostih blokov v D0.L ***
nprost  move.w (#zastave),d1
        lsr.w #2,d1
        movea.l (#zacram),a0
        clr.l d0
        bra.b nprost3
nprost1 move.l (a0)+,d2
        moveq #31,d3
        moveq #0,d4
nprost2 add.l d2,d2
        addx.l d4,d0
        dbf d3,nprost2
nprost3 dbf d1,nprost1
        rts

;*** Dodeli vmesnike za sprejem in oddajo ***
inivmes bsr.b inivme1
        move.l a0,(#rxvmes)
        bsr.b inivme1
        move.l a0,(#txavmes)
        bsr.b inivme1
        move.l a0,(#txbvmes)
        rts
inivme1 bsr.w dodeli
        bsr.w naslov
        clr.l (a0) ;pocisti pisalni/bralni kazalec v vmesniku
        rts

;*** Okvir stevilka D0.W v vmesnik A0 ***
okvirvv move.w (a0),d1 ;pisalni/bralni kazalec
        move.w #2(a0),d2
        addq.w #2,d1 ;povecaj pisalni kazalec, kontrola
        cmpi.w #dolvmes,d1
        bcs.b okvirv1
        clr.w d1
okvirv1 cmp.w d1,d2 ;prostor v vmesniku na razpolago?
        beq.b okvirv2
        move.w (a0),d2 ;stari kazalec za blok v vmesnik
        move.w d0,#4(a0,d2.w)
        move.w d1,(a0) ;shrani nov pisalni kazalec
        rts
okvirv2 bsr.w sprosti ;sprosti okvir, ce ni prostora!
        rts

;*** Stevilka okvirja v D0.W iz vmesnika A0 ***
izokvir move.w (a0),d1 ;pisalni/bralni kazalec
        move.w #2(a0),d2
        cmp.w d1,d2 ;nov okvir na razpolago?
        bne.b izokvi1
        clr.l d0 ;0 ni novega okvirja
        rts
izokvi1 move.w #4(a0,d2.w),d0 ;stevilka okvirja
        addq.w #2,d2 ;povecaj bralni kazalec, kontrola
        cmpi.w #dolvmes,d2
        bcs.w izokvi2
        clr.w d2
izokvi2 move.w d2,#2(a0) ;novi kazalec
        rts

;*** Generator psevdo-nakljucnega stevila v D0.L ***
nakljuc $00000000 ;spremenljivka psevdonakljucnega izvora (.L)
psevnak move.l (#nakljuc),d0 ;PN generator zataknjen v 0?
        bne.b psevna1
        moveq #-1,d0
psevna1 add.l d0,d0 ;polinomski generator 1+(X**28)+(X**31)
        btst #28,d0
        beq.b psevna2
        eori.w #1,d0
psevna2 btst #31,d0
        beq.b psevna3
        eori.w #1,d0
psevna3 move.l d0,(#nakljuc)
        rts

;*** Dodeli bloke in naslove za sprejem in oddajo ***
inirxad bsr.w dodeli
        move.w d0,(#smeti) ;dodeli blok za smeti
        bsr.w dodeli
        move.w d0,(#rxablok) ;dodeli blok za sprejemnik A
        bsr.w naslov
        move.w #1,#rxkanal(a0)
        movea.l #kanalad,a6 ;postavi naslove sprejemnika A
        adda.w #zacokv,a0
        movea.l a0,a5
        move.w #maxdol,d7 ;zacetni kazalec sprejemnika A
        bsr.w dodeli ;dodeli naslov za asinhroni RXB vmesnik
        bsr.w naslov
        movea.l a0,a4
        clr.w d6 ;zacetni kazalec sprejemnika B
        rts

;*** Oddaja stanja ob vklopu TNCja ***
vklopst bsr.w dodeli
        bsr.w stanje
        rts

;*** Zanka za obdelavo SCC-RXA okvirjev ***
milisek $00000000 ;milisekundni stevec (.L)
gzanka  addq.l #1,(#milisek) ;poskusni urni stevec!!!!!!!!!!!!!
        bsr.w kisstx
        bsr.w txaprek
        bsr.w kisstx
        bsr.w kissrx
        bsr.w kisstx
        bsr.w obdela
        bsr.w kisstx
        bra.b gzanka

;*** Obdelava sprejetega okvirja v bloku D0.W ***
obdela  movea.l (#rxvmes),a0
        bsr.w izokvir
        tst.w d0
        bne.b obdela1
        rts
obdela1 move.w d0,d5 ;stevilka okvirja zacasno v D5.W
        bsr.w naslov
        move.w d5,d0
        cmpi.w #1,#rxkanal(a0) ;usmeri okvir s kanala A ali B
        bne.w bobdela
        bra.w aobdela

;*** Obdelava okvirjev s kanala A D0.W+A0 ***
maxkonc equ 8 ;najvecje stevilo digijev za konec znakov
minslip equ 20 ;najmanjsa dolzina SLIP okvirja
aobdela movea.l #mojznak,a1 ;je sploh vkljuceno sito za znak?
        cmpi.b #$40,(a1)
        bne.b aobdel2
aobdel1 move.w #zacokv,#rxkanal(a0) ;KISS okvir na RS-232
        clr.w #tipokv(a0)
        movea.l (#txbvmes),a0
        bsr.w okvirvv
        rts
aobdel2 movea.l a0,a2 ;preverjanje klicnega znaka naslovnika
        adda.w #zacokv,a2
        moveq #5,d1
aobdel3 cmpm.b (a1)+,(a2)+
        dbne d1,aobdel3
        bne.b aobdel5 ;neenaki znaki, mogoce digi?
        move.b (a2),d2 ;shrani SSID naslovnika v D2.B
        moveq #maxkonc,d1 ;preveri: postavljeni vsi digi biti?
        movea.l a0,a2
        adda.w #zacokv,a2
        adda.w #13,a2
aobdel4 btst #0,(a2) ;konec klicnih znakov?
        bne.b aobdel6 ;A2 kaze na konec znakov
        addq.l #7,a2
        btst #7,(a2) ;postavljen digi bit?
        dbeq d1,aobdel4
aobdel5 bsr.w digirep ;okvir v digi-repetitor okvirjev>>>>>>>>>
        rts
aobdel6 move.b (#mojssid),d1 ;preveri SSID naslovnika v D2.B
        eor.b d1,d2
        andi.b #30,d2
        bne.b aobdel1 ;neenak SSID, poslji KISS okvir na RS-232
        addq.l #3,a2 ;izracunaj zacetek in dolzino SLIP vsebine
        suba.l a0,a2
        move.w a2,d1
        subi.w #zacokv,d1
        sub.w d1,(a0)
        cmpi.w #minslip,(a0) ;preveri dolzino SLIP okvirja
        bpl.b aobdel7
        bsr.w sprosti ;sprosti prekratek ali nicen SLIP okvir
        rts
aobdel7 move.w a2,#rxkanal(a0) ;zacetek in vrsta okvirja
        move.w #1,#tipokv(a0)
        bsr.w arpvpis ;vpisi pot v ARP tabelo>>>>>>>>>>>>>>>>>>
        movea.l (#txbvmes),a0 ;SLIP okvir na RS-232
        bsr.w okvirvv
        rts

;*** Obdelava okvirjev s kanala B D0.W+A0 ***
mojtnc  $a89c86404040 ;ASCII*2 'TNC   '
maxznak equ 10 ;max stevilo klicnih znakov v AX.25 okvirju
bobdela tst.w #tipokv(a0) ;vrsta okvirja KISS ali SLIP?
        bne.b bobdel4
        movea.l #mojtnc,a1 ;preverjanje KISS ukaza za mojtnc
        movea.l a0,a2
        adda.w #zacokv,a2
        moveq #5,d1
bobdel1 cmpm.b (a1)+,(a2)+
        dbne d1,bobdel1
        beq.b bobdel2
        move.w #zacokv,#rxkanal(a0) ;okvir v oddajo na modem
        movea.l (#txavmes),a0
        bsr.w okvirvv
        rts
bobdel2 move.w d0,-(a7) ;oddaja stanja / nastavitev parametrov
        move.w (a0),d1
        adda.w #zacokv,a0
        adda.w #16,a0
        btst #0,#-3(a0) ;preveri konec po dveh klicnih znakih
        beq.b bobdel3
        subi.w #16,d1 ;odstej klicne znake, control in PID
        bmi.b bobdel3
        cmpi.w #2,d1 ;ukaz vsaj 2 ASCII znaka?
        bcs.b bobdel3
        bsr.w ukazi ;nastavi parametre iz ukaza>>>>>>>>>>>>>>>>
bobdel3 bsr.w arpizp ;izpisi ARP tabelo>>>>>>>>>>>>>>>>>>>>>>>>
        move.w (a7)+,d0
        bsr.w stanje ;oddaja stanja na RS-232 v bloku D0.W
        rts
bobdel4 movea.l #defpot,a1 ;SLIP okvirju pripisi AX.25 glavo
        bsr.w arppot ;isci nadomestno pot po ARP tabeli v A1>>>
        move.w (a1)+,d1
        cmpi.w #maxznak,d1 ;preveri stevilo klicnih znakov
        bcs.b bobdel5
        move.w #maxznak,d1
bobdel5 mulu #7,d1 ;pomnozi znake *7 za prepisovanje
        move.w d1,d2
        addq.w #2,d1 ;dodaj prostor se za CONTROL in PID
        add.w d1,(a0) ;nova dolzina okvirja
        neg.w d1
        addi.w #zacokv,d1
        move.w d1,#rxkanal(a0) ;nov zacetek okvirja
        movea.l a0,a2 ;prepisi AX.25 glavo
        adda.w d1,a2
        bra.b bobdel7
bobdel6 move.b (a1)+,(a2)+
bobdel7 dbf d2,bobdel6
        ori.b #1,#-1(a2) ;postavi bit za konec klicnih znakov
        move.b #$03,(a2)+ ;CONTROL $03
        move.b #$cc,(a2)+ ;PID $CC
        movea.l (#txavmes),a0 ;okvir v oddajo na modem
        bsr.w okvirvv
        rts

;*** Oddaja stanja na RS-232 TNC>STATUS v bloku D0.W ***
status  $a6a882a8aaa6 ;ASCII*2 'STATUS'
stanje  move.w d0,-(a7)
        bsr.w naslov
        move.w #zacokv,#rxkanal(a0) ;zacetni naslov in KISS
        clr.w #tipokv(a0)
        move.l a0,-(a7)
        adda.w #zacokv,a0
        movea.l #status,a1 ;naslovnik STATUS
        moveq #5,d1
stanje1 move.b (a1)+,(a0)+
        dbf d1,stanje1
        move.b #$60,(a0)+ ;SSID=0
        movea.l #mojtnc,a1 ;mojtnc posiljatelj
        moveq #5,d1
stanje2 move.b (a1)+,(a0)+
        dbf d1,stanje2
        move.b #$61,(a0)+ ;SSID=0, bit za konec znakov
        move.b #$03,(a0)+ ;control=$03
        move.b #$f0,(a0)+ ;PID=$F0
        movea.l #mojznak,a1 ;izpisi mojznak
        moveq #5,d1
stanje3 move.b (a1)+,d0
        ror.b #1,d0
        move.b d0,(a0)+
        dbf d1,stanje3
        movea.l #stanje6,a1 ;izpisi mojssid za digi
        bsr.w tekst
        move.b (#mojssid),d0
        lsr.b #1,d0
        andi.l #15,d0
        bsr.w stevilo
        movea.l #stanje7,a1 ;izpisi dolzino txaglav
        bsr.w tekst
        move.l (#txaglav),d0
        bsr.w stevilo
        movea.l #stanje8,a1 ;izpisi dolzino txarep
        bsr.w tekst
        move.l (#txarep),d0
        bsr.w stevilo
        movea.l #stanje9,a1 ;izpisi tecnoba
        bsr.w tekst
        clr.l d0
        move.b (#tecnoba),d0
        bsr.w stevilo
        movea.l #stanj10,a1 ;izpis stevila blokov
        bsr.w tekst
        move.l a0,-(a7)
        bsr.w nprost
        move.l (a7)+,a0
        bsr.w stevilo
        movea.l #stanj11,a1 ;izpis casa delovanja
        bsr.w tekst
        move.l (#milisek),d0
        bsr.w stevilo
        movea.l #stanj13,a1 ;izpisi vrsto RS-232 protokola
        cmpi.b #smack,(#txbznak)
        beq.b stanje4
        movea.l #stanj14,a1
        cmpi.b #flex,(#txbznak)
        beq.b stanje4
        movea.l #stanj12,a1
stanje4 bsr.w tekst
        movea.l #stanj15,a1 ;izpisi stanje ARP (0,1,2,3)
        move.w (#arpstat),d0
        beq.b stanje5
        movea.l #stanj16,a1
        subq.w #1,d0
        beq.b stanje5
        movea.l #stanj17,a1
        subq.w #1,d0
        beq.b stanje5
        movea.l #stanj18,a1
stanje5 bsr.w tekst
        movea.l #stanj19,a1 ;izpisi default AX.25 pot za SLIP
        bsr.w tekst
        movea.l #defpot,a1
        bsr.w izpaxp
        move.l a0,d0 ;izracunaj dolzino sestavljenega okvirja
        movea.l (a7)+,a0
        sub.l a0,d0
        sub.w #zacokv,d0
        move.w d0,(a0)
        move.w (a7)+,d0 ;okvir v oddajo na RS-232
        movea.l (#txbvmes),a0
        bsr.w okvirvv
        rts
stanje6 ' SSID: '
stanje7 ' Glava: '
stanje8 ' Rep: '
stanje9 ' Tecen: '
stanj10 ' Blok: '
stanj11 ' Ura: '
stanj12 ' 0:KISS^M'
stanj13 ' 1:SMACK^M'
stanj14 ' 2:FLEX^M'
stanj15 '0:IZKLOP'
stanj16 '1:BRANJE'
stanj17 '2:VPIS-DEF'
stanj18 '3:VPIS'
stanj19 ' Pot:'

;*** Izpis AX.25 poti SLIP okvirjev iz (A1)+ v (A0)+ ***
izpaxp  move.w (a1)+,d2 ;precitaj stevilo klicnih znakov
        cmpi.w #maxznak,d2
        bcs.b izpaxp4
        move.w #maxznak,d2
        bra.w izpaxp4
izpaxp1 move.b #32,(a0)+ ;presledek pred klicnim znakom
        moveq #5,d1 ;prepisi do 6 crk klicnega znaka
izpaxp2 move.b (a1)+,d0
        ror.b #1,d0
        cmpi.b #32,d0 ;preskoci presledek?
        beq.b izpaxp3
        move.b d0,(a0)+
izpaxp3 dbf d1,izpaxp2
        move.b #45,(a0)+ ;crtica "-" do SSID
        clr.l d0
        move.b (a1)+,d0
        ror.b #1,d0
        subi.b #48,d0
        move.l d2,-(a7)
        bsr.w stevilo
        move.l (a7)+,d2
izpaxp4 dbf d2,izpaxp1
        move.b #13,(a0)+ ;povratek "^M" na koncu AX poti
        rts

;*** Prepisovanje besede iz (A1)+ v (A0)+ ***
tekst   move.b (a1)+,d0
        bne.b tekst1
        rts
tekst1  move.b d0,(a0)+
        bra.b tekst

;*** Izpis stevila D0.L v decimalni obliki v (A0)+ ***
stevilo moveq #1,d1
        moveq #-1,d2 ;stevilo decimalnih mest
        moveq #9,d3
stevil1 move.l d1,d4
        asl.l #2,d1
        add.l d4,d1
        asl.l #1,d1
        addq.w #1,d2
        cmp.l d1,d0
        dbcs d3,stevil1
stevil2 moveq #1,d1 ;izracuna mestno vrednost
        move.w d2,d3
        bra.b stevil4
stevil3 move.l d1,d4
        asl.l #2,d1
        add.l d4,d1
        asl.l #1,d1
stevil4 dbf d3,stevil3
        moveq #9,d3 ;izracuna stevilko na mestu
        moveq #47,d4
stevil5 addq.b #1,d4
        sub.l d1,d0
        dbcs d3,stevil5
        add.l d1,d0
        move.b d4,(a0)+
        dbf d2,stevil2 ;zanka po decimalnih mestih
        rts

;*** Izvedi ukaz (A0)+,D1.W nastavi parametre ***
ukazi   cmpi.b #35,(a0) ;ukaz "#" vpis IP stevilke in AX poti?
        bne.b ukazi6
        moveq #3,d4 ;precitaj stiri dec. stevila IP naslova
ukazi1  bsr.w decvhod
        tst.l d2
        bmi.b ukazi2
        rts
ukazi2  lsl.l #8,d5
        move.b d0,d5
        dbf d4,ukazi1
        bsr.w uredi ;uredi ARP tabelo za IP stevilko v D5.L
        bsr.w axpot ;precitaj AX.25 pot
        movea.l #arpzac,a1 ;preveri stevilo klicnih znakov poti
        cmpi.w #2,#4(a1)
        bcs.b ukazi3 ;pobrisi vpis s premalo klicnimi znaki
        rts
ukazi3  movea.l a1,a2 ;prepisi ARP tabelo za en vpis navzdol
        adda.w #arpblok,a2
        moveq #maxarp,d2
        subq.w #1,d2
        mulu #arpblok,d2
        lsr.l #2,d2
        bra.b ukazi5
ukazi4  move.l (a2)+,(a1)+
ukazi5  dbf d2,ukazi4
        clr.w #4(a1) ;pobrisi vpis na repu tabele
        rts
ukazi6  cmpi.b #33,(a0) ;ukaz "!" vpis AX.25 pot SLIP okvirjev?
        bne.b ukazi8
        movea.l #defpot,a1 ;default pot SLIP okvirjev
        bsr.w axpot ;precitaj AX.25 pot
        cmpi.w #2,(#defpot)
        bcc.b ukazi7
        move.w #2,(#defpot)
ukazi7  rts
ukazi8  movea.l #mojznak,a1 ;ostalo: postavi moj klicni znak
        bsr.w kliznak
        bsr.w decvhod ;precitaj in prepisi mojssid
        tst.l d2
        bmi.b ukazi9
        rts
ukazi9  add.b d0,d0
        move.b d0,(#mojssid)
        bsr.w decvhod ;precitaj in prepisi txaglav
        tst.l d2
        bmi.b ukaz10
        rts
ukaz10  move.l d0,(#txaglav)
        bsr.w decvhod ;precitaj in prepisi txarep
        tst.l d2
        bmi.b ukazi11
        rts
ukazi11 move.l d0,(#txarep)
        bsr.w decvhod ;precitaj in prepisi tecnoba
        tst.l d2
        bmi.b ukazi12
        rts
ukazi12 move.b d0,(#tecnoba)
        bsr.w decvhod ;precitaj in postavi protokol
        tst.l d2
        bmi.b ukazi13
        rts
ukazi13 move.b #smack,(#txbznak)
        cmpi.l #1,d0
        beq.b ukazi14
        move.b #flex,(#txbznak)
        cmpi.l #2,d0
        beq.b ukazi14
        move.b #nicla,(#txbznak)
ukazi14 bsr.w decvhod ;precitaj in postavi ARP stanje
        tst.l d2
        bmi.b ukazi15
        rts
ukazi15 move.w d0,(#arpstat)
        rts

;*** Precitaj AX.25 pot v (A1)+ ***
axpot   movea.l a1,a3
        clr.w (a1)+
axpot1  bsr.w beseda ;precitaj 6 crk klicnega znaka v (A1)+
        bsr.w kliznak
        bsr.w decvhod ;precitaj SSID
        tst.l d2
        bmi.b axpot2
        rts
axpot2  andi.b #15,d0 ;izracunaj SSID
        add.b d0,d0
        addi.b #96,d0
        move.b d0,(a1)+
        addq.w #1,(a3) ;povecaj in preveri stevec znakov
        cmpi.w #maxznak,(a3)
        bcs.b axpot1
        rts

;*** Poisci naslednjo besedo v ukazu (A0)+,D1.W ***
besmeja equ 48 ;meja za presledek med besedami
beseda  tst.w d1 ;poisci presledek med besedama
        beq.b beseda1
        cmpi.b #besmeja,(a0)
        bcs.b beseda1
        addq.l #1,a0
        subq.w #1,d1
        bra.b beseda
beseda1 tst.w d1 ;poisci zacetek naslednje besede
        beq.b beseda2
        cmpi.b #besmeja,(a0)
        bcc.b beseda2
        addq.l #1,a0
        subq.w #1,d1
        bra.b beseda1
beseda2 rts

;*** Klicni znak iz ukaza (A0)+,D1.W kot ASCII*2 v (A1)+ ***
kliznak moveq #5,d0 ;pobrisi obstojeci klicni znak
        movea.l a1,a2
klizna1 move.b #64,(a1)+
        dbf d0,klizna1
        moveq #5,d2 ;precitaj najvec 6 crk iz ukaza
klizna2 tst.w d1
        beq.b klizna3
        cmpi.b #besmeja,(a0)
        bcc.b klizna4
klizna3 rts
klizna4 move.b (a0)+,d0 ;veljavna crka v klicni znak
        subq.w #1,d1
        add.b d0,d0
        cmpi.b #192,d0 ;male crke v velike?
        bcs.b klizna5
        subi.b #64,d0
klizna5 move.b d0,(a2)+
        dbf d2,klizna2
        rts

;*** Decimalno stevilo iz ukaza v D0.L, zastavica D2 ***
decvhod clr.l d0
        clr.l d2
        bsr.w beseda ;poisci naslednjo besedo v ukazu
decvho1 tst.w d1 ;se en znak iz ukaza?
        beq.b decvho2
        cmpi.b #besmeja,(a0)
        bcc.b decvho3
decvho2 rts
decvho3 lsl.l #1,d0 ;pomnozi prejsnje stevilo z 10
        move.l d0,d2
        lsl.l #2,d0
        add.l d2,d0
        move.b (a0)+,d2 ;precita in pretvori znak iz ukaza
        subq.w #1,d1
        andi.l #15,d2
        add.l d2,d0 ;pristeje nov znak
        moveq #-1,d2 ;zastavica
        bra.b decvho1

;*** Digi-repetitor okvirjev D0.W+A0 ***
maxdigi equ 7 ;najvecje stevilo digijev -1
digirep move.w #zacokv,#rxkanal(a0)
        adda.w #zacokv,a0 ;preskoci naslovnika in izvor
        adda.w #14,a0
        moveq #maxdigi,d1
digire1 btst #0,#-1(a0) ;konec klicnih znakov?
        beq.b digire2
        bsr.w sprosti ;sprosti okvir, nasel konec znakov
        rts
digire2 btst #7,#6(a0) ;ze postavljen digi bit?
        beq.b digire3
        addq.l #7,a0
        dbf d1,digire1
        bsr.w sprosti ;sprosti okvir, prevec klicnih znakov
        rts
digire3 movea.l #mojznak,a1 ;primerjaj 6 crk znaka, brez SSID
        movea.l a0,a2
        moveq #5,d2
digire4 cmpm.b (a1)+,(a2)+
        dbne d2,digire4
        beq.b digire5
        bsr.w sprosti ;sprosti okvir, ni moj digi znak
        rts
digire5 move.b #6(a0),d1 ;primerjaj SSID digi znaka
        move.b (#mojssid),d2
        eor.b d2,d1
        andi.b #30,d1
        beq.b digire6
        bsr.w sprosti ;sprosti okvir, digi z napacnim SSIDjem
        rts
digire6 bset #7,#6(a0) ;postavi digi bit!
        movea.l (#txavmes),a0 ;okvir v oddajni A vmesnik
        bsr.w okvirvv
        rts

;*** Urejanje ARP tabele za nov vpis IP stevilke D5.L ***
ablok16 equ 4 ;hitra konstanta ((arpblok/16)-1)
uredi   movea.l #arpzac,a1 ;poisci enak IP v ARP tabeli
        moveq #1,d4
uredi1  tst.w #4(a1) ;konec veljavnih vpisov v tabeli?
        bne.b uredi2
        adda.w #arpblok,a1
        addq.w #1,d4
        bra.b uredi3
uredi2  cmp.l (a1),d5 ;nasel enak IP v tabeli?
        beq.b uredi3
        adda.w #arpblok,a1
        addq.w #1,d4
        cmpi.w #maxarp,d4 ;konec ARP tabele?
        bcs.b uredi1
uredi3  subq.w #1,d4 ;konec urejanja ARP tabele?
        beq.b uredi5
        movea.l a1,a2 ;premakni en vpis v ARP tabeli
        suba.w #arpblok,a2
        move.l a2,d3
        moveq #ablok16,d2
uredi4  move.l (a2)+,(a1)+ ;prepisi 16 bajtov v vsaki zanki
        move.l (a2)+,(a1)+
        move.l (a2)+,(a1)+
        move.l (a2)+,(a1)+
        dbf d2,uredi4
        movea.l d3,a1
        bra.b uredi3
uredi5  move.l d5,(a1)+ ;vpisi IP stevilko D5.L na zacetek
        rts

;*** Vpis ARP tabele iz okvirja (A0), pusti pri miru D0 ***
srcip   equ 12 ;odmik IP stevilke posiljatelja
arpvpis cmpi.w #2,(#arpstat) ;vkljucen vpis ARP tabele?
        bcc.b arpvpi1
        rts
arpvpi1 bne.b arpvpi3 ;vpis IP stevilke za default pot?
        movea.l a0,a1
        adda.w #zacokv,a1
        addq.l #7,a1
        movea.l #defpot,a2
        addq.l #2,a2
        moveq #5,d2
arpvpi2 cmpm.b (a1)+,(a2)+ ;primerjaj klicni znak brez SSID
        dbne d2,arpvpi2
        bne.b arpvpi3
        rts
arpvpi3 movea.l a0,a1 ;poisci IP stevilko posiljatelja
        adda.w #rxkanal(a0),a1
        adda.w #srcip,a1
        move.b (a1)+,d5
        lsl.l #8,d5
        move.b (a1)+,d5
        lsl.l #8,d5
        move.b (a1)+,d5
        lsl.l #8,d5
        move.b (a1)+,d5
        bsr.w uredi ;uredi ARP tabelo za IP stevilko D5.L
        clr.l d2 ;izracunaj in prepisi stevilo klicnih znakov
        move.w #rxkanal(a0),d2
        sub.w #zacokv,d2
        divu #7,d2
        move.w d2,(a1)+
        movea.l a0,a2 ;prepisi klicne znake za povratno zvezo!!
        adda.w #zacokv,a2
        addq.l #7,a2 ;posiljatelj v naslovnika
        bsr.b arpvpi6
        suba.w #14,a2 ;naslovnik v posiljatelja
        bsr.b arpvpi6
        subq.w #3,d2 ;digiji?
        bpl.b arpvpi4
        rts
arpvpi4 movea.l a0,a2 ;prepisi digije v obratnem vrstnem redu
        adda.w #rxkanal(a0),a2
        suba.w #9,a2
arpvpi5 bsr.b arpvpi6
        suba.w #14,a2
        dbf d2,arpvpi5
        rts
arpvpi6 moveq #5,d1 ;prepisi 6 crk klicnega znaka
arpvpi7 move.b (a2)+,(a1)+
        dbf d1,arpvpi7
        move.b (a2)+,d1 ;prepisi in ocisti SSID
        andi.b #$7e,d1
        move.b d1,(a1)+
        rts

;*** IP okvir (A0), nadomestna pot v A1, pusti pri miru D0 ***
destip  equ 16 ;odmik IP stevilke naslovnika
arppot  tst.w (#arpstat) ;ARP vkljucen?
        bne.b arppot1
        rts
arppot1 movea.l a0,a2 ;precitaj IP stevilko naslovnika v D1.L
        adda.w #zacokv,a2
        adda.w #destip,a2
        move.b (a2)+,d1
        lsl.l #8,d1
        move.b (a2)+,d1
        lsl.l #8,d1
        move.b (a2)+,d1
        lsl.l #8,d1
        move.b (a2)+,d1
        movea.l #arpzac,a2 ;zanka po ARP tabeli
        move.w #maxarp,d2
        bra.b arppot3
arppot2 cmp.l (a2),d1 ;primerjaj IP stevilke naslovnikov?
        beq.b arppot4
        adda.w #arpblok,a2
arppot3 tst.w #4(a2) ;konec veljavnih vpisov v tabeli?
        dbeq d2,arppot2
        rts
arppot4 movea.l a2,a1 ;nasel IP naslov v tabeli, postavi A1
        addq.l #4,a1
        rts

;*** Izpis ARP tabele v obliki UI okvirjev ***
maxarp  equ 16 ;najvecje stevilo vpisov
arpblok equ 80 ;dolzina enega vpisa v ARP tabeli (glej ablok16)
arpizp  tst.w (#arpstat) ;ARP vkljucen?
        bne.b arpizp1
        rts
arpizp1 movea.l #arpzac,a3 ;zanka po ARP tabeli
        move.w #maxarp,d5
        bra.b arpizp3
arpizp2 bsr.w iproute ;izpis enega vpisa v tabeli
        adda.w #arpblok,a3
arpizp3 tst.w #4(a3) ;obstojeci vpis v ARP tabeli?
        dbeq d5,arpizp2
        rts

;*** Izpisi en vpis iz tabele (A3), pusti pri miru D5 ***
routes  $a49eaaa88aa6 ;ASCII*2 'ROUTES'
iproute bsr.w dodeli ;dodeli blok za en vpis iz tabele
        move.w d0,-(a7)
        bne.b iprout1
        move.w (a7)+,d0
        rts
iprout1 bsr.w naslov ;naslov bloka za odgovor v A0
        move.w #zacokv,#rxkanal(a0) ;zacetni naslov in KISS
        clr.w #tipokv(a0)
        move.l a0,-(a7)
        adda.w #zacokv,a0
        movea.l #routes,a1 ;naslovnik ROUTES
        moveq #5,d1
iprout2 move.b (a1)+,(a0)+
        dbf d1,iprout2
        move.b #$60,(a0)+ ;SSID=0
        movea.l #mojtnc,a1 ;mojtnc posiljatelj
        moveq #5,d1
iprout3 move.b (a1)+,(a0)+
        dbf d1,iprout3
        move.b #$61,(a0)+ ;SSID=0, bit za konec znakov
        move.b #$03,(a0)+ ;control=$03
        move.b #$f0,(a0)+ ;PID=$F0
        movea.l a3,a1 ;izpisi IP stevilko
        clr.l d0
        move.b (a1)+,d0
        bsr.w stevilo
        move.b #46,(a0)+
        clr.l d0
        move.b (a1)+,d0
        bsr.w stevilo
        move.b #46,(a0)+
        clr.l d0
        move.b (a1)+,d0
        bsr.w stevilo
        move.b #46,(a0)+
        clr.l d0
        move.b (a1)+,d0
        bsr.w stevilo
        bsr.w izpaxp ;izpisi AX.25 pot
        move.l a0,d0 ;izracunaj dolzino sestavljenega okvirja
        movea.l (a7)+,a0
        sub.l a0,d0
        sub.w #zacokv,d0
        move.w d0,(a0)
        move.w (a7)+,d0 ;okvir v oddajo na RS-232
        movea.l (#txbvmes),a0
        bsr.w okvirvv
        rts

;;; Konec programa ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 